#include "TimeUp.h"



TimeUp::TimeUp(sf::RenderWindow* hwnd, Input* input) : Level(hwnd, input)
{
	backgroundTexture.loadFromFile("Assets/Sprites/Levels/Time Up/background.png");	//Load the background texture and set the size to the window size
	backgroundSprite.setTexture(&backgroundTexture);
	backgroundSprite.setSize(sf::Vector2f(1024, 768));
}


TimeUp::~TimeUp()
{
}

void TimeUp::handleInput(float dt)
{

}

void TimeUp::update(float dt)
{
	if (Timer::setWaitTime(3.0, dt))	//After 3 seconds have passed, we change to the lives screen
	{
		currentLevel = Level::QueryLevel(LevelType_Lives);
	}
}

void TimeUp::render()
{
	window->draw(backgroundSprite);
}